local t = LoadFallbackB();

t[#t+1] = Def.ActorFrame{
	LoadFont("Common Normal") .. {
		Text="LENGTH:";
		InitCommand=cmd(x,Left()+6;y,Top()+90;zoom,0.5;align,0,0;diffuse,color("#A4A4A4"));
	};
	LoadFont("Common Normal") .. {
		Text="BPM:";
		InitCommand=cmd(x,Left()+156;y,Top()+90;zoom,0.5;align,0,0;diffuse,color("#A4A4A4"));
	};
};

local ut = Def.ActorFrame{
	BeginCommand=cmd(draworder,200);
	LoadFont("Common Normal")..{
		Name="songArtist";
		InitCommand=cmd(x,CenterX()-84;y,Top()+120+4;zoom,0.4;align,0,0;uppercase,true);
		OffCommand=cmd(decelerate,0.05;addy,900;);
		SetCommand=function(self)
			local song;
			local sub="";
			local art="";
			if GAMESTATE:IsCourseMode() then
			else
				song=GAMESTATE:GetCurrentSong();
				sub=song:GetDisplaySubTitle();
				art=song:GetDisplayArtist();
				self:settext(art);
			end;
		end;
	};
	-- Working as SubTitle
	LoadFont("Common Normal")..{
		Name="songTitle";
		InitCommand=cmd(x,CenterX()-112;y,Top()+120+4;zoom,0.4;halign,0);
		OffCommand=cmd(decelerate,0.05;addy,900);
		SetCommand=function(self)
			local song;
			local tit="";
			if GAMESTATE:IsCourseMode() then
				song=GAMESTATE:GetCurrentCourse();
				tit=song:GetDisplayFullTitle();
				
			else
				song=GAMESTATE:GetCurrentSong();
				tit=song:GetDisplayMainTitle();
			end;
			self:settextf("%s",tit);
		end;
	};
};

local function updateTitle(self)
	local upTit = self:GetChild("songTitle");
	local upArt = self:GetChild("songArtist");
	local curSelection = GAMESTATE:GetCurrentSong();
	local curSelCourse = GAMESTATE:GetCurrentCourse();
	upTit:maxwidth(280);
	upArt:maxwidth(540);
	if curSelection or curSelCourse then
		local song;
		local tit="";
		local sub="";
		local art="";
		if GAMESTATE:IsCourseMode() then
			song=GAMESTATE:GetCurrentCourse();
			tit=song:GetDisplayFullTitle();
		else
			song=GAMESTATE:GetCurrentSong();
			tit=song:GetDisplayMainTitle();
			art=song:GetDisplayArtist();
			
			if song:GetDisplaySubTitle() == "" then
				sub=""
			else
				sub=" - " .. song:GetDisplaySubTitle();
			end
			
			upTit:settext("");
		end;
		upTit:diffuse(color("1,1,1,1"));
		upTit:strokecolor(Color("White"));
		
		upArt:settext(art .. sub);
		upArt:diffuse(color("1,1,1,1"));
		upArt:strokecolor(Color("White"));
	else
		upTit:settext("");
		upArt:settext("");
	end;
end;

ut.InitCommand=cmd(SetUpdateFunction,updateTitle);
t[#t+1] = ut;

t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(draworder,-99;x,CenterX();y,Bottom();valign,1;zoomto,Width(),40);
		OnCommand=function(self) self:diffuse(color(LoadFile("ThemeColor.cfg","Settings"))) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		InitCommand=cmd(x,Left()+4+128+8;y,Bottom()-20;align,0,1;zoomto,150,16);
		OnCommand=function(self) self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		InitCommand=cmd(x,Right()-4-128-8;y,Bottom()-20;align,1,1;zoomto,150,16);
		OnCommand=function(self) self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		Name="SearchTitle";
		InitCommand=cmd(xy,CenterX(),Bottom()-20;zoomto,268,16;valign,1);
		OnCommand=function(self) self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		InitCommand=cmd(xy,CenterX(),Bottom();valign,1;setsize,Width(),16;diffuse,Black());
	};
};

return t;